(define/contract (min-trio-degree n edges)
  (-> exact-integer? (listof (listof exact-integer?)) exact-integer?)
  (define adj (make-vector (add1 n) (mutable-set)))
  (for ([edge edges])
    (define u (first edge))
    (define v (second edge))
    (set-add! (vector-ref adj u) v)
    (set-add! (vector-ref adj v) u))
  (define min-degree +inf.0)
  (for ([u (in-range 1 (add1 n))] #:when (>= (set-count (vector-ref adj u)) 2))
    (for ([v (in-set (vector-ref adj u))] #:when (> v u))
      (for ([w (in-set (vector-ref adj u))] #:when (> w v))
        (when (and (set-member? (vector-ref adj v) w))
          (define degree (+ (- (set-count (vector-ref adj u)) 2)
                           (- (set-count (vector-ref adj v)) 2)
                           (- (set-count (vector-ref adj w)) 2)))
          (set! min-degree (min min-degree degree))))))
  (if (= min-degree +inf.0) 0 min-degree))