(define (evaluate s knowledge)
  (let ((knowledge-hash (make-hash)))
    (for ([pair knowledge])
      (hash-set! knowledge-hash (car pair) (cadr pair)))
    (let loop ((i 0) (res '()))
      (if (>= i (string-length s))
          (list->string (reverse res))
          (let ((c (string-ref s i)))
            (if (char=? c #\( )
                (let-values (((key end) (extract-key s (+ i 1))))
                  (loop (+ end 1)
                        (append (reverse (string->list (hash-ref knowledge-hash key "?"))) res))
                (loop (+ i 1) (cons c res))))))))

(define (extract-key s start)
  (let loop ((i start) (chars '()))
    (if (char=? (string-ref s i) #\) )
        (values (list->string (reverse chars)) i)
        (loop (+ i 1) (cons (string-ref s i) chars)))))