(define/contract (min-side-jumps obstacles)
  (-> (listof exact-integer?) exact-integer?)
  (define n (length obstacles))
  (define dp (make-vector 3 1))
  (vector-set! dp 1 0)
  (for ([i (in-range 1 n)])
    (define obs (list-ref obstacles i))
    (define new-dp (make-vector 3 +inf.0))
    (for ([lane (in-range 3)])
      (when (not (= (add1 lane) obs))
        (vector-set! new-dp lane (vector-ref dp lane))))
    (for ([lane (in-range 3)])
      (when (not (= (add1 lane) obs))
        (for ([other-lane (in-range 3)])
          (when (and (not (= other-lane lane)) (not (= (add1 other-lane) obs)))
            (vector-set! new-dp lane (min (vector-ref new-dp lane)
                                         (+ (vector-ref new-dp other-lane) 1)))))))
    (set! dp new-dp))
  (apply min (vector->list dp)))