(define (make-string-sorted s)
  (define mod 1000000007)
  (define n (string-length s))
  (define fact (make-vector (+ n 1) 1))
  (for ([i (in-range 1 (+ n 1))])
    (vector-set! fact i (modulo (* (vector-ref fact (- i 1)) i) mod)))

  (define inv (make-vector (+ n 1) 1))
  (for ([i (in-range 2 (+ n 1))])
    (vector-set! inv i (modulo (* inv (- mod (quotient mod i))) mod)))

  (define inv-fact (make-vector (+ n 1) 1))
  (for ([i (in-range 1 (+ n 1))])
    (vector-set! inv-fact i (modulo (* (vector-ref inv-fact (- i 1)) (vector-ref inv i)) mod)))

  (define freq (make-hash))
  (for ([c (in-string s)])
    (hash-update! freq c add1 0))

  (define res 0)
  (for ([i (in-range 0 n)])
    (define c (string-ref s i))
    (for ([(k v) (in-hash freq)]
          #:when (char<? k c))
      (define temp (vector-ref fact (- n i 1)))
      (hash-update! freq k sub1)
      (for ([(k2 v2) (in-hash freq)])
        (set! temp (modulo (* temp (vector-ref inv-fact v2)) mod)))
      (set! res (modulo (+ res temp) mod))
      (hash-update! freq k add1))
    (hash-update! freq c sub1)
    (when (= (hash-ref freq c) 0)
      (hash-remove! freq c)))
  res)