(define/contract (maximum-population logs)
  (-> (listof (listof exact-integer?)) exact-integer?)
  (define years (make-hash))
  (for ([log logs])
    (define birth (first log))
    (define death (second log))
    (for ([year (in-range birth death)])
      (hash-update! years year add1 0)))
  (define max-pop 0)
  (define result-year 1950)
  (for ([(year pop) (in-hash years)])
    (cond
      [(> pop max-pop)
       (set! max-pop pop)
       (set! result-year year)]
      [(= pop max-pop)
       (when (< year result-year)
         (set! result-year year))]))
  (if (zero? max-pop) 1950 result-year))