(define/contract (max-sum-min-product nums)
  (-> (listof exact-integer?) exact-integer?)
  (define mod 1000000007)
  (define n (length nums))
  (define prefix (make-vector (+ n 1) 0))
  (for ([i (in-range n)])
    (vector-set! prefix (+ i 1) (+ (vector-ref prefix i) (list-ref nums i))))

  (define left (make-vector n -1))
  (define right (make-vector n n))
  (define stack '())

  (for ([i (in-range n)])
    (while (and (not (null? stack)) (< (list-ref nums (car stack)) (list-ref nums i)))
      (vector-set! right (car stack) i)
      (set! stack (cdr stack)))
    (if (not (null? stack))
        (vector-set! left i (car stack))
        (void))
    (set! stack (cons i stack)))

  (define max-product 0)
  (for ([i (in-range n)])
    (define l (vector-ref left i))
    (define r (vector-ref right i))
    (define sum (- (vector-ref prefix r) (vector-ref prefix (+ l 1))))
    (set! max-product (max max-product (* (list-ref nums i) sum))))

  (modulo max-product mod))