(define/contract (sum-of-floored-pairs nums)
  (-> (listof exact-integer?) exact-integer?)
  (define MOD 1000000007)
  (define max-num (apply max nums))
  (define freq (make-vector (+ max-num 1) 0))
  (for ([num nums])
    (vector-set! freq num (+ (vector-ref freq num) 1)))

  (define prefix (make-vector (+ max-num 1) 0))
  (for ([i (in-range 1 (+ max-num 1))])
    (vector-set! prefix i (+ (vector-ref prefix (- i 1)) (vector-ref freq i))))

  (define result 0)
  (for ([y nums])
    (let loop ([d 1])
      (define lower (* y d))
      (define upper (* y (+ d 1))))
      (when (<= lower max-num)
        (define cnt (if (> upper max-num)
                        (- (vector-ref prefix max-num) (vector-ref prefix (- lower 1)))
                        (- (vector-ref prefix (- upper 1)) (vector-ref prefix (- lower 1)))))
        (set! result (modulo (+ result (* d cnt)) MOD))
        (loop (+ d 1)))))
  result)