(define/contract (min-speed-on-time dist hour)
  (-> (listof exact-integer?) flonum? exact-integer?)
  (define (can-reach? speed)
    (let loop ([d dist] [time 0.0])
      (if (null? d)
          (<= time hour)
          (let ([t (/ (car d) speed)])
            (loop (cdr d) 
                  (if (null? (cdr d)) 
                      (+ time t) 
                      (+ time (ceiling t))))))))

  (define left 1)
  (define right 10000000)
  (define result -1)

  (let binary-search ([l left] [r right])
    (when (<= l r)
      (define mid (quotient (+ l r) 2))
      (if (can-reach? mid)
          (begin
            (set! result mid)
            (binary-search l (sub1 mid)))
          (binary-search (add1 mid) r))))
  result)