(define (count-sub-islands grid1 grid2)
  (let* ([m (vector-length grid1)]
         [n (vector-length (vector-ref grid1 0))]
         [count 0])
    (define (dfs i j)
      (when (and (>= i 0) (< i m) (>= j 0) (< j n) (= (vector-ref (vector-ref grid2 i) j) 1)
        (vector-set! (vector-ref grid2 i) j 0)
        (dfs (add1 i) j)
        (dfs (sub1 i) j)
        (dfs i (add1 j))
        (dfs i (sub1 j))))
    (for ([i (in-range m)])
      (for ([j (in-range n)])
        (when (and (= (vector-ref (vector-ref grid2 i) j) 1) (= (vector-ref (vector-ref grid1 i) j) 0))
          (dfs i j)))))
    (for ([i (in-range m)])
      (for ([j (in-range n)])
        (when (= (vector-ref (vector-ref grid2 i) j) 1)
          (set! count (add1 count))
          (dfs i j)))))
    count))