#lang racket

(define (min-difference nums queries)
  (define n (length nums))
  (define m (length queries))
  (define prefix (make-vector (add1 n) (make-hash)))
  (for ([i (in-range 1 (add1 n))])
    (define prev (vector-ref prefix (sub1 i)))
    (define curr (hash-copy prev))
    (define num (list-ref nums (sub1 i)))
    (hash-update! curr num add1 (lambda () 0))
    (vector-set! prefix i curr))

  (define result '())
  (for ([q queries])
    (define l (first q))
    (define r (second q))
    (define left-hash (vector-ref prefix l))
    (define right-hash (vector-ref prefix (add1 r)))
    (define curr-hash (make-hash))
    (for ([(k v) right-hash])
      (define diff (- v (hash-ref left-hash k 0)))
      (when (> diff 0)
        (hash-set! curr-hash k diff)))
    (define sorted-keys (sort (hash-keys curr-hash) <))
    (define min-diff +inf.0)
    (for ([i (in-range 1 (length sorted-keys))])
      (define diff (- (list-ref sorted-keys i) (list-ref sorted-keys (sub1 i))))
      (when (< diff min-diff)
        (set! min-diff diff)))
    (if (or (null? sorted-keys) (= min-diff +inf.0))
        (set! result (cons -1 result))
        (set! result (cons min-diff result))))
  (reverse result))