(define/contract (rotate-grid grid k)
  (-> (listof (listof exact-integer?)) exact-integer? (listof (listof exact-integer?)))
  (define m (length grid))
  (define n (length (car grid)))
  (define layers (quotient (min m n) 2))

  (define (get-layer l)
    (define top (for/list ([j (in-range l (- n l))]) (list-ref (list-ref grid l) j)))
    (define right (for/list ([i (in-range (+ l 1) (- m l))]) (list-ref (list-ref grid i) (- n l 1))))
    (define bottom (for/list ([j (in-range (- n l 2) (- l 1) -1)]) (list-ref (list-ref grid (- m l 1)) j)))
    (define left (for/list ([i (in-range (- m l 2) l -1)]) (list-ref (list-ref grid i) l)))
    (append top right bottom left))

  (define (set-layer! l rotated)
    (define len (length rotated))
    (define idx 0)
    (for ([j (in-range l (- n l))])
      (set-car! (list-tail (list-ref grid l) j) (list-ref rotated idx))
      (set! idx (modulo (+ idx 1) len)))
    (for ([i (in-range (+ l 1) (- m l))])
      (set-car! (list-tail (list-ref grid i) (- n l 1)) (list-ref rotated idx))
      (set! idx (modulo (+ idx 1) len)))
    (for ([j (in-range (- n l 2) (- l 1) -1)])
      (set-car! (list-tail (list-ref grid (- m l 1)) j) (list-ref rotated idx))
      (set! idx (modulo (+ idx 1) len)))
    (for ([i (in-range (- m l 2) l -1)])
      (set-car! (list-tail (list-ref grid i) l) (list-ref rotated idx))
      (set! idx (modulo (+ idx 1) len))))

  (for ([l (in-range layers)])
    (define layer (get-layer l))
    (define len (length layer))
    (define rot (modulo k len))
    (define rotated (append (list-tail layer rot) (take layer rot)))
    (set-layer! l rotated))

  grid)