(define/contract (can-merge trees)
  (-> (listof (listof exact-integer?)) (listof exact-integer?))
  (let* ([leaf->root (make-hash)]
         [roots (make-hash)]
         [all-leaves (mutable-set)])
    (for ([tree trees])
      (let ([root-val (car tree)]
            [left (cadr tree)]
            [right (caddr tree)])
        (hash-set! roots root-val tree)
        (when (not (null? left))
          (hash-set! leaf->root left root-val)
          (set-add! all-leaves left)
        (when (not (null? right))
          (hash-set! leaf->root right root-val)
          (set-add! all-leaves right))))
    (let ([root-candidates (filter (lambda (x) (not (set-member? all-leaves x))) (hash-keys roots))])
      (if (not (= (length root-candidates) 1))
          '()
          (let ([root-val (car root-candidates)]
                [visited (mutable-set)])
            (define (build-bst node-val lower upper)
              (if (or (null? node-val) (set-member? visited node-val))
                  (if (null? node-val) #t #f)
                  (let ([tree (hash-ref roots node-val #f)])
                    (if (not tree)
                        #f
                        (let ([left (cadr tree)]
                              [right (caddr tree)])
                          (set-add! visited node-val)
                          (and (or (null? left) (< lower left node-val))
                               (or (null? right) (< node-val right upper))
                               (build-bst left lower node-val)
                               (build-bst right node-val upper))))))
            (if (build-bst root-val -inf.0 +inf.0)
                (let ([result '()])
                  (define (inorder node-val)
                    (unless (null? node-val)
                      (let ([tree (hash-ref roots node-val)])
                        (inorder (cadr tree))
                        (set! result (cons node-val result))
                        (inorder (caddr tree)))))
                  (inorder root-val)
                  (reverse result))
                '()))))))