(define/contract (max-points points)
  (-> (listof (listof exact-integer?)) exact-integer?)
  (let* ([m (length points)]
         [n (length (car points))]
         [dp (make-vector m (make-vector n 0))])
    (for ([i (in-range m)])
      (vector-set! dp i (make-vector n 0)))
    (for ([j (in-range n)])
      (vector-set! (vector-ref dp 0) j (list-ref (list-ref points 0) j)))
    (for ([i (in-range 1 m)])
      (let ([left (make-vector n 0)]
            [right (make-vector n 0)])
        (vector-set! left 0 (vector-ref (vector-ref dp (- i 1)) 0))
        (for ([j (in-range 1 n)])
          (vector-set! left j (max (vector-ref (vector-ref dp (- i 1)) j) 
                                    (- (vector-ref left (- j 1)) 1)))
        (vector-set! right (- n 1) (vector-ref (vector-ref dp (- i 1)) (- n 1)))
        (for ([j (in-range (- n 2) -1 -1)])
          (vector-set! right j (max (vector-ref (vector-ref dp (- i 1)) j) 
                                    (- (vector-ref right (+ j 1)) 1)))
        (for ([j (in-range n)])
          (vector-set! (vector-ref dp i) j (+ (list-ref (list-ref points i) j) 
                                              (max (vector-ref left j) (vector-ref right j)))))))
    (apply max (vector->list (vector-ref dp (- m 1))))))