(define/contract (split-painting segments)
  (-> (listof (listof exact-integer?)) (listof (listof exact-integer?)))
  (define events (make-hash))
  (for ([seg segments])
    (let ([start (first seg)]
          [end (second seg)]
          [color (third seg)])
      (hash-update! events start (lambda (v) (+ v color)) 0)
      (hash-update! events end (lambda (v) (- v color)) 0)))
  (define sorted-positions (sort (hash-keys events) <))
  (define result '())
  (define prev-pos 0)
  (define current-color 0)
  (for ([pos sorted-positions])
    (when (> current-color 0)
      (set! result (cons (list prev-pos pos current-color) result)))
    (set! current-color (+ current-color (hash-ref events pos)))
    (set! prev-pos pos))
  (reverse result))