(define/contract (can-see-persons-count heights)
  (-> (listof exact-integer?) (listof exact-integer?))
  (let ([stack '()]
        [result (make-list (length heights) 0)])
    (for ([i (in-range (sub1 (length heights)) -1 -1)])
      (let ([h (list-ref heights i)])
        (let loop ()
          (when (and (not (null? stack)) (> (car stack) h))
            (set! result (list-set result i (add1 (list-ref result i))))
            (set! stack (cdr stack))
            (loop)))
        (unless (null? stack)
          (set! result (list-set result i (add1 (list-ref result i)))))
        (set! stack (cons h stack)))
    result))