(define/contract (min-space-wasted k nums)
  (-> exact-integer? (listof exact-integer?) exact-integer?)
  (let* ([n (length nums)]
         [prefix (make-vector (add1 n) 0)]
         [max-in-range (make-vector n (make-vector n 0))]
         [dp (make-vector (add1 n) (make-vector (add1 k) +inf.0))])
    (for ([i (in-range n)])
      (vector-set! prefix (add1 i) (+ (vector-ref prefix i) (list-ref nums i))))
    (for ([i (in-range n)])
      (let ([current-max (list-ref nums i)])
        (vector-set! (vector-ref max-in-range i) i current-max)
        (for ([j (in-range (add1 i) n)])
          (set! current-max (max current-max (list-ref nums j)))
          (vector-set! (vector-ref max-in-range i) j current-max))))
    (vector-set! (vector-ref dp 0) 0 0)
    (for ([i (in-range n)])
      (for ([j (in-range k)])
        (when (< (vector-ref (vector-ref dp i) j) +inf.0)
          (for ([t (in-range i n)])
            (let ([wasted (- (* (vector-ref (vector-ref max-in-range i) t) (- (add1 t) i))
                             (- (vector-ref prefix (add1 t)) (vector-ref prefix i))))])
              (vector-set! (vector-ref dp (add1 t)) (add1 j)
                           (min (vector-ref (vector-ref dp (add1 t)) (add1 j))
                                (+ (vector-ref (vector-ref dp i) j) wasted))))))))
    (apply min (vector->list (vector-ref dp n)))))