#lang racket

(define (score-of-students s answers)
  (define n (string-length s))
  (define nums (make-vector (quotient (add1 n) 2) 0))
  (define ops (make-vector (quotient n 2) #\space))
  (define (parse)
    (for ([i (in-range n)]
          [c (in-string s)])
      (if (even? i)
          (vector-set! nums (quotient i 2) (- (char->integer c) 48))
          (vector-set! ops (quotient i 2) c))))
  (parse)
  (define m (vector-length nums))
  (define dp (make-vector m (make-hash)))
  (for ([i (in-range m)])
    (vector-set! dp i (make-hash))
    (hash-set! (vector-ref dp i) (vector-ref nums i) #t))
  (for ([len (in-range 2 (add1 m))])
    (for ([i (in-range 0 (- m len -1))])
      (define j (+ i len -1))
      (define res (make-hash))
      (for ([k (in-range i j)])
        (for ([(left _) (in-hash (vector-ref dp i k))])
          (for ([(right _) (in-hash (vector-ref dp (add1 k) j))])
            (define op (vector-ref ops k))
            (define val (if (char=? op #\+) (+ left right) (* left right)))
            (when (<= val 1000)
              (hash-set! res val #t)))))
      (vector-set! dp i j res)))
  (define correct (let loop ([i 0] [acc (vector-ref nums 0)])
                    (if (>= i (vector-length ops))
                        acc
                        (let ([op (vector-ref ops i)]
                              [num (vector-ref nums (add1 i))])
                          (loop (add1 i) (if (char=? op #\+) (+ acc num) (* acc num)))))))
  (define possible (hash-keys (vector-ref dp 0 (sub1 m))))
  (define total 0)
  (for ([ans answers])
    (cond [(= ans correct) (set! total (+ total 5))]
          [(member ans possible) (set! total (+ total 2))]))
  total)