(define (count-valid-words sentence)
  (define (valid? word)
    (define (valid-char? c)
      (or (char-alphabetic? c)
          (char-numeric? c)
          (char=? c #\-)
          (char=? c #\!)
          (char=? c #\.)
          (char=? c #\,)))
    (define (valid-hyphen? word)
      (let loop ((i 0) (hyphen-pos -1))
        (cond
          ((>= i (string-length word)) #t)
          ((char=? (string-ref word i) #\-)
           (if (or (= hyphen-pos -1)
                   (and (< hyphen-pos (- i 1))
                       (> (- (string-length word) 1) i)
                       (char-alphabetic? (string-ref word (- i 1)))
                       (char-alphabetic? (string-ref word (+ i 1)))))
               (loop (+ i 1) i)
               #f))
          (else (loop (+ i 1) hyphen-pos)))))
    (define (valid-punctuation? word)
      (let ((last-char (string-ref word (- (string-length word) 1))))
        (or (char-alphabetic? last-char)
            (char-numeric? last-char)
            (and (or (char=? last-char #\!)
                     (char=? last-char #\.)
                     (char=? last-char #\,))
                 (= (string-length word) 1))
            (and (or (char=? last-char #\!)
                     (char=? last-char #\.)
                     (char=? last-char #\,))
                 (not (ormap (lambda (c) (or (char=? c #\!)
                                            (char=? c #\.)
                                            (char=? c #\,)))
                           (string->list (substring word 0 (- (string-length word) 1)))))))))
    (and (not (string=? word ""))
         (andmap valid-char? (string->list word))
         (valid-hyphen? word)
         (valid-punctuation? word)))

  (let ((words (string-split sentence)))
    (length (filter valid? words))))