#lang racket

(define (count-combinations pieces positions)
  (define n (length pieces))
  (define pos (list->vector positions))
  (define dirs (make-hash))
  (hash-set! dirs 'rook '((1 0) (-1 0) (0 1) (0 -1)))
  (hash-set! dirs 'bishop '((1 1) (1 -1) (-1 1) (-1 -1)))
  (hash-set! dirs 'queen '((1 0) (-1 0) (0 1) (0 -1) (1 1) (1 -1) (-1 1) (-1 -1)))

  (define (valid? new-positions)
    (define occupied (make-hash))
    (for ([i (in-range n)])
      (hash-set! occupied (list-ref new-positions i) #t))
    (for ([i (in-range n)])
      (for ([j (in-range n)])
        (when (and (not (= i j)) (equal? (list-ref new-positions i) (list-ref new-positions j)))
          (return #f)))))
    #t)

  (define (generate-moves i)
    (define piece (list-ref pieces i))
    (define (x y) (list-ref (vector-ref pos i) 0))
    (define (y y) (list-ref (vector-ref pos i) 1))
    (define directions (hash-ref dirs piece))
    (define moves (list (list (x) (y))))
    (for ([dir directions])
      (define dx (first dir))
      (define dy (second dir))
      (define nx (+ (x) dx))
      (define ny (+ (y) dy))
      (while (and (>= nx 1) (<= nx 8) (>= ny 1) (<= ny 8))
        (set! moves (cons (list nx ny) moves))
        (set! nx (+ nx dx))
        (set! ny (+ ny dy))))
    moves)

  (define (backtrack idx current result)
    (if (= idx n)
        (if (valid? current) (cons current result) result)
        (let ([moves (generate-moves idx)])
          (for/fold ([res result]) ([move moves])
            (backtrack (+ idx 1) (cons move current) res)))))

  (length (backtrack 0 '() '())))