(define/contract (minimized-maximum n quantities)
  (-> exact-integer? (listof exact-integer?) exact-integer?)
  (define (can-distribute x)
    (let loop ([q quantities] [sum 0])
      (if (null? q)
          (<= sum n)
          (let ([cnt (ceiling (/ (car q) x))])
            (loop (cdr q) (+ sum cnt))))))
  (let binary-search ([left 1] [right (apply max quantities)])
    (if (= left right)
        left
        (let ([mid (quotient (+ left right) 2)])
          (if (can-distribute mid)
              (binary-search left mid)
              (binary-search (+ mid 1) right))))))