(define/contract (check-almost-equivalent word1 word2)
  (-> string? string? boolean?)
  (let ((count1 (make-hash))
        (count2 (make-hash)))
    (for ((c word1))
      (hash-update! count1 c add1 0))
    (for ((c word2))
      (hash-update! count2 c add1 0))
    (for/fold ((result #t))
              (((k v) count1)
               #:break (not result))
      (and result (<= (abs (- v (hash-ref count2 k 0))) 3))
    (for/fold ((result #t))
              (((k v) count2)
               #:break (not result))
      (and result (<= (abs (- v (hash-ref count1 k 0))) 3))))