(define (decode-ciphertext encoded-text rows)
  (if (zero? (string-length encoded-text))
      ""
      (let* ((cols (quotient (string-length encoded-text) rows))
             (mat (make-vector rows (make-string cols #\space)))
             (i 0)
             (j 0)
             (k 0))
        (for ([ch (in-string encoded-text)])
          (vector-set! (vector-ref mat i) j ch)
          (set! i (add1 i))
          (when (>= i rows)
            (set! i 0)
            (set! j (add1 j))))
        (let loop ((i 0) (j 0) (res '()))
          (if (or (>= i rows) (>= j cols))
              (list->string (reverse res))
              (loop (add1 i) (add1 j) (cons (string-ref (vector-ref (vector-ref mat i) j)) res))))))))