(define/contract (min-subarray-len target nums)
  (-> exact-integer? (listof exact-integer?) exact-integer?)
  (let loop ([left 0] [right 0] [sum 0] [min-length +inf.0])
    (if (>= right (length nums))
        (if (= min-length +inf.0) 0 min-length)
        (let ([new-sum (+ sum (list-ref nums right))])
          (if (>= new-sum target)
              (let ([new-min (min min-length (+ (- right left) 1))])
                (loop (add1 left) (add1 left) (- new-sum (list-ref nums left)) new-min))
              (loop left (add1 right) new-sum min-length))))))