(define (find-order num-courses prerequisites)
  (let* ((in-degree (make-vector num-courses 0))
         (graph (make-vector num-courses '()))
         (queue '())
         (result '()))
    (for ([prerequisite prerequisites])
      (let ((course (cadr prerequisite))
            (dependent (car prerequisite)))
        (vector-set! graph course (cons dependent (vector-ref graph course)))
        (vector-set! in-degree dependent (add1 (vector-ref in-degree dependent)))))
    (for ([i (in-range num-courses)])
      (when (zero? (vector-ref in-degree i))
        (set! queue (cons i queue))))
    (let loop ()
      (unless (null? queue)
        (let ((current (car queue)))
          (set! queue (cdr queue))
          (set! result (cons current result))
          (for ([neighbor (vector-ref graph current)])
            (vector-set! in-degree neighbor (sub1 (vector-ref in-degree neighbor)))
            (when (zero? (vector-ref in-degree neighbor))
              (set! queue (cons neighbor queue))))
          (loop))))
    (if (= (length result) num-courses)
        (reverse result)
        '())))