#lang racket

(define/contract (maximum-detonation bombs)
  (-> (listof (listof exact-integer?)) exact-integer?)
  (define n (length bombs))
  (define adj (make-vector n '()))
  (for ([i (in-range n)])
    (for ([j (in-range n)])
      (when (and (not (= i j))
                 (<= (+ (sqr (- (first (list-ref bombs i)) (first (list-ref bombs j))))
                        (sqr (- (second (list-ref bombs i)) (second (list-ref bombs j)))))
                     (sqr (third (list-ref bombs i)))))
        (vector-set! adj i (cons j (vector-ref adj i))))))
  (define (bfs start)
    (define visited (make-vector n #f))
    (define q (make-queue))
    (enqueue! q start)
    (vector-set! visited start #t)
    (define count 1)
    (while (not (queue-empty? q))
      (define u (dequeue! q))
      (for ([v (in-list (vector-ref adj u))])
        (when (not (vector-ref visited v))
          (vector-set! visited v #t)
          (enqueue! q v)
          (set! count (add1 count)))))
    count)
  (define max-count 0)
  (for ([i (in-range n)])
    (set! max-count (max max-count (bfs i))))
  max-count)