(define/contract (max-total-fruits fruits startPos k)
  (-> (listof (listof exact-integer?)) exact-integer? exact-integer? exact-integer?)
  (let* ([n (length fruits)]
         [prefix (make-vector (add1 n) 0)]
         [positions (make-vector n 0)])
    (for ([i (in-range n)])
      (vector-set! positions i (first (list-ref fruits i))))
    (for ([i (in-range n)])
      (vector-set! prefix (add1 i) (+ (vector-ref prefix i) (second (list-ref fruits i)))))
    (define (find-left pos)
      (let loop ([left 0] [right (sub1 n)])
        (if (> left right)
            -1
            (let ([mid (quotient (+ left right) 2)])
              (if (>= (vector-ref positions mid) pos)
                  (loop left (sub1 mid))
                  (loop (add1 mid) right))))))
    (define (find-right pos)
      (let loop ([left 0] [right (sub1 n)])
        (if (> left right)
            -1
            (let ([mid (quotient (+ left right) 2)])
              (if (<= (vector-ref positions mid) pos)
                  (loop (add1 mid) right)
                  (loop left (sub1 mid)))))))
    (define left-bound (find-left (- startPos k)))
    (define right-bound (find-right (+ startPos k)))
    (if (or (= left-bound -1) (= right-bound -1))
        0
        (let ([max-fruits 0])
          (for ([i (in-range (add1 left-bound))])
            (let ([left-pos (vector-ref positions i)])
            (for ([j (in-range right-bound (sub1 n))])
              (let ([right-pos (vector-ref positions j)])
                (if (<= (+ (- right-pos left-pos) (min (- startPos left-pos) (- right-pos startPos))) k)
                    (set! max-fruits (max max-fruits (- (vector-ref prefix (add1 j)) (vector-ref prefix i)))))))
          max-fruits))))