(define (find-words board words)
  (define rows (length board))
  (define cols (if (null? board) 0 (length (car board))))

  (define trie (make-hash))
  (define result '())

  (define (build-trie)
    (for ([word words])
      (let loop ([node trie] [chars (string->list word)])
        (if (null? chars)
            (hash-set! node 'end #t)
            (let ([c (car chars)])
              (unless (hash-has-key? node c)
                (hash-set! node c (make-hash)))
              (loop (hash-ref node c) (cdr chars)))))))

  (define (dfs i j node path)
    (let ([c (list-ref (list-ref board i) j)])
      (unless (hash-has-key? node c) (void))
      (let ([next-node (hash-ref node c)])
        (when (hash-has-key? next-node 'end)
          (set! result (cons (list->string (reverse path)) result))
          (hash-remove! next-node 'end))
        (let ([temp c])
          (list-set! (list-ref board i) j #\0)
          (for ([dir '((-1 0) (1 0) (0 -1) (0 1))])
            (let ([ni (+ i (car dir))]
                  [nj (+ j (cadr dir))])
              (when (and (>= ni 0) (< ni rows) (>= nj 0) (< nj cols)
                    (not (char=? (list-ref (list-ref board ni) nj) #\0)))
                (dfs ni nj next-node (cons (list-ref (list-ref board ni) nj) path))))
          (list-set! (list-ref board i) j temp)))))

  (build-trie)
  (for ([i (in-range rows)])
    (for ([j (in-range cols)])
      (let ([c (list-ref (list-ref board i) j)])
        (when (hash-has-key? trie c)
          (dfs i j trie (list c)))))
  result)