(define (execute-instructions n startPos s)
  (define (simulate x y instructions)
    (let loop ((i 0) (x x) (y y))
      (if (>= i (string-length instructions))
          0
          (let ((dx (case (string-ref instructions i)
                      ((#\L) 0)
                      ((#\R) 0)
                      ((#\U) -1)
                      ((#\D) 1)))
                (dy (case (string-ref instructions i)
                      ((#\L) -1)
                      ((#\R) 1)
                      ((#\U) 0)
                      ((#\D) 0))))
            (let ((new-x (+ x dx))
                  (new-y (+ y dy)))
              (if (or (< new-x 0) (>= new-x n) (< new-y 0) (>= new-y n))
                  i
                  (loop (+ i 1) new-x new-y))))))
  (let ((result (make-vector (string-length s) 0)))
    (for ((i (in-range (string-length s))))
      (vector-set! result i (simulate (car startPos) (cdr startPos) (substring s i)))
    (vector->list result)))