(define/contract (find-lonely nums)
  (-> (listof exact-integer?) (listof exact-integer?))
  (let ([freq (make-hash)])
    (for ([num nums])
      (hash-update! freq num add1 (lambda () 0)))
    (filter (lambda (num)
              (and (= (hash-ref freq num) 1)
                   (not (hash-has-key? freq (+ num 1)))
                   (not (hash-has-key? freq (- num 1)))))
            nums)))