(define/contract (get-skyline buildings)
  (-> (listof (listof exact-integer?)) (listof (listof exact-integer?)))
  (define points '())
  (for ([b buildings])
    (define l (first b))
    (define r (second b))
    (define h (third b))
    (set! points (cons (list l (- h)) points))
    (set! points (cons (list r h) points)))
  (set! points (sort points (λ (a b) (or (< (first a) (first b))
                                        (and (= (first a) (first b))
                                             (< (second a) (second b)))))))
  (define max-heap (make-heap (λ (a b) (> a b))))
  (heap-add! max-heap 0)
  (define prev 0)
  (define result '())
  (for ([p points])
    (define x (first p))
    (define h (second p))
    (if (< h 0)
        (heap-add! max-heap (- h))
        (heap-remove! max-heap h))
    (define current (heap-max max-heap))
    (when (not (= current prev))
      (set! result (cons (list x current) result))
      (set! prev current)))
  (reverse result))