(define (repeat-limited-string s repeatLimit)
  (let* ((counts (make-hash))
         (chars (string->list s)))
    (for-each (lambda (c)
                (hash-update! counts c add1 0))
              chars)
    (let loop ((result '())
               (prev-char #f)
               (prev-count 0))
      (let ((max-char (for/fold ((max-char #f))
                                 (((k v) counts)
                                  #:when (and (> v 0)
                                              (or (not max-char)
                                                  (char>? k max-char))))
                        k)))
        (if (not max-char)
            (list->string (reverse result))
            (let ((count (hash-ref counts max-char)))
              (if (and (equal? max-char prev-char)
                       (>= prev-count repeatLimit))
                  (let ((next-char (for/fold ((next-char #f))
                                             (((k v) counts)
                                              #:when (and (> v 0)
                                                          (not (equal? k max-char))
                                              #:when (or (not next-char)
                                                         (char>? k next-char))))
                                    k)))
                    (if (not next-char)
                        (list->string (reverse result))
                        (begin
                          (hash-update! counts next-char sub1)
                          (loop (cons next-char result)
                                next-char
                                1))))
                  (let ((use (min count repeatLimit)))
                    (hash-update! counts max-char (lambda (v) (- v use)))
                    (loop (append (make-list use max-char) result)
                          max-char
                          (if (equal? max-char prev-char)
                              (+ prev-count use)
                              use))))))))))