(define/contract (count-pairs nums k)
  (-> (listof exact-integer?) exact-integer? exact-integer?)
  (define gcd-count (make-hash))
  (define total 0)
  (for ([num nums])
    (define g (gcd num k))
    (for ([(g2 cnt) (in-hash gcd-count)])
      (when (zero? (modulo (* g g2) k))
        (set! total (+ total cnt))))
    (hash-update! gcd-count g add1 (lambda () 0)))
  total)