(define/contract (minimum-white-tiles floor num-carpets carpet-len)
  (-> string? exact-integer? exact-integer? exact-integer?)
  (define n (string-length floor))
  (define dp (make-vector (add1 num-carpets) (make-vector (add1 n) 0)))
  (for ([i (in-range 1 (add1 n))])
    (for ([k (in-range 0 (add1 num-carpets))])
      (if (zero? k)
          (vector-set! (vector-ref dp k) i (+ (vector-ref (vector-ref dp k) (sub1 i)) 
                                               (if (char=? (string-ref floor (sub1 i)) #\1) 1 0)))
          (vector-set! (vector-ref dp k) i 
                       (min (vector-ref (vector-ref dp k) (sub1 i)) 
                            (if (>= (- i carpet-len) 0)
                                (vector-ref (vector-ref (sub1 k)) (- i carpet-len))
                                (vector-ref (vector-ref (sub1 k)) 0))))))))
  (vector-ref (vector-ref dp num-carpets) n))