(define/contract (max-value-of-coins piles k)
  (-> (listof (listof exact-integer?)) exact-integer? exact-integer?)
  (define n (length piles))
  (define dp (make-vector (add1 k) 0))
  (for ([pile (in-list piles)])
    (define m (length pile))
    (define prefix (make-vector (add1 m) 0))
    (for ([i (in-range 1 (add1 m))])
      (vector-set! prefix i (+ (vector-ref prefix (sub1 i)) (list-ref pile (sub1 i)))))
    (for ([i (in-range k 0 -1)])
      (for ([j (in-range 1 (add1 (min m i)))])
        (vector-set! dp i (max (vector-ref dp i)
                               (+ (vector-ref prefix j) (vector-ref dp (- i j))))))))
  (vector-ref dp k))