(define (minimize-result expression)
  (let* ((plus-pos (string-contains expression "+"))
         (a (substring expression 0 plus-pos))
         (b (substring expression (+ plus-pos 1)))
    (define (eval-expr left-a mid-a mid-b right-b)
      (let* ((left (if (string=? left-a "") 1 (string->number left-a)))
             (middle-a (string->number mid-a))
             (middle-b (string->number mid-b))
             (right (if (string=? right-b "") 1 (string->number right-b)))
        (* left right (+ middle-a middle-b))))

    (define min-val +inf.0)
    (define result "")

    (for ([i (in-range (string-length a))])
      (for ([j (in-range 1 (+ (string-length b) 1))])
        (let* ((left-a (substring a 0 i))
               (mid-a (substring a i))
               (mid-b (substring b 0 j))
               (right-b (substring b j))
               (current (eval-expr left-a mid-a mid-b right-b)))
          (when (< current min-val)
            (set! min-val current)
            (set! result (string-append "(" left-a mid-a "+" mid-b right-b ")"))))))
    result))