(define/contract (count-lattice-points circles)
  (-> (listof (listof exact-integer?)) exact-integer?)
  (define points (mutable-set))
  (for ([circle circles])
    (define x (first circle))
    (define y (second circle))
    (define r (third circle))
    (for ([i (in-range (- x r) (+ x r 1))])
      (for ([j (in-range (- y r) (+ y r 1))])
        (when (<= (+ (expt (- i x) 2) (expt (- j y) 2)) (expt r 2))
          (set-add! points (cons i j)))))
  (set-count points))