(define/contract (full-bloom-flowers flowers people)
  (-> (listof (listof exact-integer?)) (listof exact-integer?) (listof exact-integer?))
  (define starts (sort (map first flowers) <))
  (define ends (sort (map second flowers) <))
  (define (count-before lst x)
    (let loop ([low 0]
               [high (length lst)])
      (if (< low high)
          (let ([mid (quotient (+ low high) 2)])
            (if (<= (list-ref lst mid) x)
                (loop (add1 mid) high)
                (loop low mid)))
          low)))
  (for/list ([p people])
    (- (count-before starts p) (count-before ends (sub1 p)))))