#lang racket

(require data/heap)

(define (maximum-minutes grid)
  (define m (length grid))
  (define n (if (zero? m) 0 (length (car grid))))

  (define (valid? r c) (and (>= r 0) (< r m) (>= c 0) (< c n)))

  (define dirs '((0 . 1) (1 . 0) (0 . -1) (-1 . 0)))

  (define fire-time (make-vector m (make-vector n +inf.0)))

  (define q (make-heap (lambda (a b) (< (car a) (car b)))))

  (for ([i (in-range m)])
    (for ([j (in-range n)])
      (when (equal? (list-ref (list-ref grid i) j) 1)
        (heap-add! q (cons 0 (cons i j)))
        (vector-set! (vector-ref fire-time i) j 0))))

  (define (spread-fire)
    (while (not (heap-empty? q))
      (define current (heap-min q))
      (heap-remove-min! q)
      (define t (car current))
      (define r (cdr (cdr current)))
      (define c (cdr current))
      (for ([dir dirs])
        (define nr (+ r (car dir)))
        (define nc (+ c (cdr dir)))
        (when (and (valid? nr nc)
                   (equal? (list-ref (list-ref grid nr) nc) 0)
                   (= (vector-ref (vector-ref fire-time nr) nc) +inf.0))
          (vector-set! (vector-ref fire-time nr) nc (+ t 1))
          (heap-add! q (cons (+ t 1) (cons nr nc)))))))

  (spread-fire)

  (define (can-reach? wait)
    (define visited (make-vector m (make-vector n #f)))
    (define q (make-heap (lambda (a b) (> (car a) (car b)))))
    (when (and (valid? 0 0) (>= (vector-ref (vector-ref fire-time 0) 0) wait))
      (heap-add! q (cons wait (cons 0 0)))
      (vector-set! (vector-ref visited 0) 0 #t))
    (define found #f)
    (while (and (not (heap-empty? q)) (not found))
      (define current (heap-min q))
      (heap-remove-min! q)
      (define t (car current))
      (define r (cdr (cdr current)))
      (define c (cdr current))
      (when (and (= r (- m 1)) (= c (- n 1)))
        (set! found #t)
        (break))
      (for ([dir dirs])
        (define nr (+ r (car dir)))
        (define nc (+ c (cdr dir)))
        (when (and (valid? nr nc)
                   (equal? (list-ref (list-ref grid nr) nc) 0)
                   (not (vector-ref (vector-ref visited nr) nc))
          (define nt (+ t 1))
          (define ft (vector-ref (vector-ref fire-time nr) nc))
          (when (or (and (= nr (- m 1)) (= nc (- n 1)) (<= nt ft))
                (< nt ft))
            (vector-set! (vector-ref visited nr) nc #t)
            (heap-add! q (cons nt (cons nr nc)))))))
    found)

  (define (binary-search left right)
    (define res -1)
    (while (<= left right)
      (define mid (quotient (+ left right) 2))
      (if (can-reach? mid)
          (begin (set! res mid)
                 (set! left (+ mid 1)))
          (set! right (- mid 1))))
    res)

  (if (can-reach? (* m n))
      (* m n)
      (binary-search 0 (* m n))))