(define/contract (digit-count num)
  (-> string? boolean?)
  (let ([counts (make-vector 10 0)])
    (for ([c (in-string num)])
      (let ([digit (- (char->integer c) (char->integer #\0))])
        (vector-set! counts digit (+ (vector-ref counts digit) 1))))
    (for/and ([i (in-range (string-length num))])
      (let ([digit (- (char->integer (string-ref num i)) (char->integer #\0))])
        (= digit (vector-ref counts i))))))