(define/contract (array-replace nums operations)
  (-> (listof exact-integer?) (listof (listof exact-integer?)) (listof exact-integer?))
  (let ([ht (make-hash)])
    (for ([num nums] [i (in-naturals)])
      (hash-set! ht num i))
    (for ([op operations])
      (let ([old (first op)] [new (second op)])
        (when (hash-has-key? ht old)
          (let ([idx (hash-ref ht old)])
            (hash-remove! ht old)
            (hash-set! ht new idx)))))
    (let ([result (make-vector (length nums) 0)])
      (for ([(num idx) (in-hash ht)])
        (vector-set! result idx num))
      (vector->list result))))