(define/contract (kth-smallest root k)
  (-> (or/c null? tree-node?) exact-positive-integer? exact-integer?)
  (let ([stack '()] [node root] [count 0])
    (let loop ()
      (when (or (not (null? node)) (not (null? stack)))
        (while (not (null? node))
          (set! stack (cons node stack))
          (set! node (tree-node-left node)))
        (set! node (car stack))
        (set! stack (cdr stack))
        (set! count (add1 count))
        (when (= count k)
          (return (tree-node-val node)))
        (set! node (tree-node-right node)))
      (loop))))