(define/contract (distinct-names ideas)
  (-> (listof string?) exact-integer?)
  (define groups (make-hash))
  (for ([idea ideas])
    (define key (substring idea 0 1))
    (define suffix (substring idea 1))
    (hash-update! groups key (lambda (v) (set-add v suffix)) (set)))

  (define keys (hash-keys groups))
  (define n (length keys))
  (define result 0)

  (for ([i (in-range n)])
    (for ([j (in-range (add1 i) n)])
      (define key1 (list-ref keys i))
      (define key2 (list-ref keys j))
      (define set1 (hash-ref groups key1))
      (define set2 (hash-ref groups key2))
      (define common (set-count (set-intersect set1 set2)))
      (define diff1 (- (set-count set1) common))
      (define diff2 (- (set-count set2) common))
      (set! result (+ result (* 2 diff1 diff2)))))

  result)