(define/contract (number-of-pairs nums)
  (-> (listof exact-integer?) (listof exact-integer?))
  (let ([freq (make-hash)])
    (for ([num nums])
      (hash-update! freq num add1 0))
    (let-values ([(pairs leftover) 
                  (for/fold ([pairs 0] [leftover 0]) 
                            ([(k v) (in-hash freq)])
                    (values (+ pairs (quotient v 2)) 
                            (+ leftover (remainder v 2))))])
      (list pairs leftover))))