(define (count-excellent-pairs nums k)
  (define unique-nums (remove-duplicates nums))
  (define (bit-count x)
    (if (zero? x) 0 (+ (bitwise-and x 1) (bit-count (arithmetic-shift x -1)))))
  (define bit-counts (map bit-count unique-nums))
  (define freq (make-hash))
  (for ([bc bit-counts])
    (hash-update! freq bc add1 0))
  (define sorted-bits (sort (hash-keys freq) <))
  (define result 0)
  (define n (length sorted-bits))
  (for ([i (in-range n)])
    (define a (list-ref sorted-bits i))
    (define required (- k a))
    (define j (lower-bound sorted-bits required))
    (for ([m (in-range j n)])
      (define b (list-ref sorted-bits m))
      (define count-a (hash-ref freq a))
      (define count-b (hash-ref freq b))
      (set! result (+ result (* count-a count-b)))))
  result)

(define (lower-bound lst target)
  (define (search left right)
    (if (> left right)
        left
        (let* ([mid (quotient (+ left right) 2)]
               [mid-val (list-ref lst mid)])
          (if (< mid-val target)
              (search (+ mid 1) right)
              (search left (- mid 1))))))
  (search 0 (- (length lst) 1)))