(define/contract (closest-meeting-node edges node1 node2)
  (-> (listof exact-integer?) exact-integer? exact-integer? exact-integer?)
  (define n (length edges))
  (define (bfs start)
    (define dist (make-vector n -1))
    (define q (make-queue))
    (enqueue! q start)
    (vector-set! dist start 0)
    (let loop ()
      (unless (queue-empty? q)
        (define u (dequeue! q))
        (define v (list-ref edges u))
        (when (and (not (= v -1)) (= (vector-ref dist v) -1))
          (vector-set! dist v (+ (vector-ref dist u) 1))
          (enqueue! q v))
        (loop)))
    dist)
  (define dist1 (bfs node1))
  (define dist2 (bfs node2))
  (define min-dist +inf.0)
  (define result -1)
  (for ([i (in-range n)])
    (define d1 (vector-ref dist1 i))
    (define d2 (vector-ref dist2 i))
    (when (and (>= d1 0) (>= d2 0))
      (define current-max (max d1 d2))
      (cond
        [(< current-max min-dist)
         (set! min-dist current-max)
         (set! result i)]
        [(= current-max min-dist)
         (when (< i result)
           (set! result i))])))
  result)