(define (edge-score edges)
  (define n (vector-length edges))
  (define scores (make-hash))
  (for ([i (in-range n)])
    (define neighbor (vector-ref edges i))
    (hash-update! scores neighbor (lambda (v) (+ v i)) 0))
  (define max-score (apply max (hash-values scores)))
  (define candidates (filter (lambda (k) (= (hash-ref scores k) max-score)) (hash-keys scores)))
  (apply min candidates))