(define/contract (shifting-letters s shifts)
  (-> string? (listof (listof exact-integer?)) string?)
  (define n (string-length s))
  (define diff (make-vector n 0))
  (for ([shift shifts])
    (define start (first shift))
    (define end (second shift))
    (define dir (third shift))
    (vector-set! diff start (+ (vector-ref diff start) (if (= dir 1) 1 -1)))
    (when (< (+ end 1) n)
      (vector-set! diff (+ end 1) (- (vector-ref diff (+ end 1)) (if (= dir 1) 1 -1)))))
  (define prefix 0)
  (define result (make-string n))
  (for ([i (in-range n)])
    (set! prefix (+ prefix (vector-ref diff i)))
    (define c (char->integer (string-ref s i)))
    (define shifted (modulo (+ (- c 97) prefix) 26))
    (string-set! result i (integer->char (+ shifted 97))))
  result)