#lang racket

(define (build-matrix k row-conditions col-conditions)
  (define (topo-sort edges k)
    (define in-degrees (make-hash))
    (define adj (make-hash))
    (for ([i (in-range 1 (add1 k))])
      (hash-set! in-degrees i 0)
      (hash-set! adj i '()))
    (for ([edge edges])
      (match-define (list u v) edge)
      (hash-update! adj u (λ (lst) (cons v lst)))
    (for ([u (in-range 1 (add1 k))])
      (for ([v (hash-ref adj u '())])
        (hash-update! in-degrees v add1 1)))
    (define q (make-queue))
    (for ([u (in-range 1 (add1 k))])
      (when (zero? (hash-ref in-degrees u))
        (enqueue! q u)))
    (define result '())
    (let loop ()
      (unless (queue-empty? q)
        (define u (dequeue! q))
        (set! result (cons u result))
        (for ([v (hash-ref adj u '())])
          (hash-update! in-degrees v sub1)
          (when (zero? (hash-ref in-degrees v))
            (enqueue! q v)))
        (loop)))
    (if (= (length result) k) (reverse result) #f))

  (define row-order (topo-sort row-conditions k))
  (define col-order (topo-sort col-conditions k))
  (unless (and row-order col-order)
    (return '()))
  (define row-pos (make-hash))
  (define col-pos (make-hash))
  (for ([i (in-range k)])
    (hash-set! row-pos (list-ref row-order i) i)
    (hash-set! col-pos (list-ref col-order i) i))
  (define matrix (build-list k (λ (_) (make-list k 0))))
  (for ([num (in-range 1 (add1 k))])
    (define i (hash-ref row-pos num))
    (define j (hash-ref col-pos num))
    (list-set! (list-ref matrix i) j num))
  matrix)