(define/contract (maximum-robots chargeTimes runningCosts budget)
  (-> (listof exact-integer?) (listof exact-integer?) exact-integer? exact-integer?)
  (define n (length chargeTimes))
  (define max-k 0)
  (define (sliding-window k)
    (define window (make-deque))
    (define sum 0)
    (for ([i (in-range n)])
      (set! sum (+ sum (list-ref runningCosts i)))
      (when (>= (deque-count window) 0)
        (when (>= (deque-count window) k)
          (set! sum (- sum (list-ref runningCosts (- i k))))
          (when (equal? (deque-front window) (- i k))
            (deque-remove-front! window)))
      (while (and (not (deque-empty? window))
                  (>= (list-ref chargeTimes (deque-back window))
                         (list-ref chargeTimes i)))
        (deque-remove-back! window))
      (deque-add-back! window i)
      (when (>= i (- k 1))
        (define total (+ (list-ref chargeTimes (deque-front window)) (* k sum)))
        (when (<= total budget)
          (set! max-k k)
          #t)))
    #f)
  (define (binary-search left right)
    (when (<= left right)
      (define mid (quotient (+ left right) 2))
      (if (sliding-window mid)
          (binary-search (+ mid 1) right)
          (binary-search left (- mid 1)))))
  (binary-search 1 n)
  max-k)