(define/contract (min-meeting-rooms-iii n meetings)
  (-> exact-integer? (listof (listof exact-integer?)) exact-integer?)
  (define meetings-sorted (sort meetings (λ (a b) (< (car a) (car b)))))
  (define available-rooms (make-priority-queue))
  (for ([i n]) (priority-queue-push! available-rooms i))
  (define busy-rooms (make-priority-queue))
  (define max-rooms 0)
  (for ([meeting meetings-sorted])
    (define start (first meeting))
    (define end (second meeting))
    (while (and (not (priority-queue-empty? busy-rooms))
                (<= (car (priority-queue-min busy-rooms)) start))
      (define room (cadr (priority-queue-min busy-rooms)))
      (priority-queue-pop! busy-rooms)
      (priority-queue-push! available-rooms room))
    (if (priority-queue-empty? available-rooms)
        (begin
          (define room (cadr (priority-queue-min busy-rooms)))
          (priority-queue-pop! busy-rooms)
          (priority-queue-push! busy-rooms (cons end room)))
        (begin
          (define room (priority-queue-min available-rooms))
          (priority-queue-pop! available-rooms)
          (priority-queue-push! busy-rooms (cons end room))))
    (set! max-rooms (max max-rooms (priority-queue-count busy-rooms))))
  max-rooms)